/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.service;

import java.time.Duration;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.deputy.internal.api.Deputy;
import org.openvpms.deputy.internal.model.query.Query;
import org.openvpms.deputy.internal.model.roster.Roster;
import org.openvpms.deputy.internal.service.QueryHelper;
import org.openvpms.deputy.internal.service.QueryService;
import org.openvpms.deputy.internal.service.RosterSynchroniser;
import org.openvpms.deputy.internal.service.Rosters;
import org.openvpms.mapping.model.Mapping;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SynchronisationManager
implements Runnable {
    private final int days;
    private final Mappings<Entity> areas;
    private final Deputy deputy;
    private final QueryService queryService;
    private final int maxResults;
    private final RosterSynchroniser rosterSynchroniser;
    private AtomicBoolean stop = new AtomicBoolean();
    private static final Logger log = LoggerFactory.getLogger(SynchronisationManager.class);

    SynchronisationManager(int days, Mappings<Entity> areas, Mappings<User> users, Deputy deputy, QueryService queryService, ArchetypeService service) {
        this(days, areas, users, deputy, queryService, service, 500);
    }

    SynchronisationManager(int days, Mappings<Entity> areas, Mappings<User> users, Deputy deputy, QueryService queryService, ArchetypeService service, int maxResults) {
        this.days = days;
        this.areas = areas;
        this.deputy = deputy;
        this.queryService = queryService;
        this.maxResults = maxResults;
        this.rosterSynchroniser = new RosterSynchroniser(areas, users, deputy, queryService, service);
    }

    @Override
    public void run() {
        LocalDate initial = LocalDate.now();
        this.run(initial);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(LocalDate initial) {
        long time = System.currentTimeMillis();
        int count = 0;
        List<Object> areasMappings = Collections.emptyList();
        try {
            LocalDate start = initial;
            LocalDate end = start.plusDays(1L);
            ZoneId zone = TimeZone.getDefault().toZoneId();
            areasMappings = this.getActiveAreas();
            for (count = 0; count < this.days; ++count) {
                Date from = Date.from(start.atStartOfDay().atZone(zone).toInstant());
                Date to = Date.from(end.atStartOfDay().atZone(zone).toInstant());
                for (Mapping mapping : areasMappings) {
                    if (this.stopped()) break;
                    Rosters rosters = this.getDeputyRosters(mapping, from, to);
                    if (this.stopped()) break;
                    this.synchronise(mapping, from, to, rosters);
                }
                start = end;
                end = start.plusDays(1L);
            }
        }
        catch (Throwable exception) {
            if (this.stopped()) {
                log.debug("Roster synchronisation terminated");
            } else {
                log.error("Roster synchronisation terminated due to error: " + exception.getMessage(), exception);
            }
        }
        finally {
            if (log.isInfoEnabled()) {
                long elapsed = System.currentTimeMillis() - time;
                Duration duration = Duration.ofMillis(elapsed);
                long hours = duration.toHours();
                long minutes = duration.minusHours(hours).toMinutes();
                long seconds = duration.minusHours(hours).minusMinutes(minutes).getSeconds();
                log.info("Synchronised " + areasMappings.size() + " areas for " + count + " days starting from " + initial + " in " + hours + ":" + minutes + ":" + seconds);
            }
        }
    }

    void stop() {
        this.stop.set(true);
    }

    private List<Mapping> getActiveAreas() {
        ArrayList<Mapping> result = new ArrayList<Mapping>();
        for (Mapping mapping : this.areas.getMappings()) {
            Reference source = mapping.getSource();
            if (this.queryService.isActive(source)) {
                result.add(mapping);
                continue;
            }
            log.warn("Excluding inactive area=" + source + " from synchronisation");
        }
        return result;
    }

    private boolean stopped() {
        return this.stop.get() || Thread.currentThread().isInterrupted();
    }

    private void synchronise(Mapping mapping, Date start, Date end, Rosters rosters) {
        List<Act> events = this.queryService.getEvents(mapping.getSource(), start, end);
        for (Act event : events) {
            if (this.stopped()) break;
            this.rosterSynchroniser.synchroniseFromEvent(event, rosters);
        }
        if (!this.stopped()) {
            for (Roster roster : rosters.getUnprocessed()) {
                if (this.stopped()) break;
                this.rosterSynchroniser.synchroniseFromRoster(roster, rosters);
            }
        }
    }

    private Rosters getDeputyRosters(Mapping mapping, Date from, Date to) {
        Query query = new Query();
        Target target = mapping.getTarget();
        query.addSearch("area", "OperationalUnit", "eq", Long.valueOf(target.getId()));
        query.addSearch("from", "Date", "ge", from);
        query.addSearch("to", "Date", "lt", to);
        query.orderBy("Id", true);
        List<Roster> matches = QueryHelper.query(query, this.maxResults, this.deputy::getRosters, this.stop);
        return new Rosters(matches, this.deputy);
    }
}

