/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.service;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.ws.rs.NotFoundException;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.deputy.internal.api.Deputy;
import org.openvpms.deputy.internal.i18n.DeputyMessages;
import org.openvpms.deputy.internal.model.organisation.Employee;
import org.openvpms.deputy.internal.model.organisation.OperationalUnit;
import org.openvpms.deputy.internal.model.roster.Roster;
import org.openvpms.deputy.internal.model.roster.RosterData;
import org.openvpms.deputy.internal.service.DeputyHelper;
import org.openvpms.deputy.internal.service.QueryService;
import org.openvpms.deputy.internal.service.Rosters;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RosterSynchroniser {
    private final Mappings<Entity> areas;
    private final Mappings<User> users;
    private final Deputy deputy;
    private final ArchetypeService service;
    private final QueryService queryService;
    private static final Logger log = LoggerFactory.getLogger(RosterSynchroniser.class);

    RosterSynchroniser(Mappings<Entity> areas, Mappings<User> users, Deputy deputy, QueryService queryService, ArchetypeService service) {
        this.areas = areas;
        this.users = users;
        this.deputy = deputy;
        this.service = service;
        this.queryService = queryService;
    }

    Roster synchroniseFromEvent(Act event) {
        return this.synchroniseFromEvent(this.service.getBean((IMObject)event));
    }

    Roster synchroniseFromEvent(IMObjectBean bean) {
        return this.synchroniseFromEvent(bean, new Rosters(this.deputy));
    }

    Roster synchroniseFromEvent(Act event, Rosters rosters) {
        IMObjectBean bean = this.service.getBean((IMObject)event);
        return this.synchroniseFromEvent(bean, rosters);
    }

    Roster synchroniseFromEvent(IMObjectBean bean, Rosters rosters) {
        Roster result = null;
        Reference areaRef = bean.getTargetRef("schedule");
        if (areaRef != null) {
            String name;
            Target area = this.areas.getTarget(areaRef);
            ActIdentity identity = DeputyHelper.getSynchronisationId(bean);
            if (area != null) {
                Target employee;
                Reference userRef = bean.getTargetRef("user");
                Target target = employee = userRef != null ? this.users.getTarget(userRef) : null;
                if (!this.hasSynchronised((Identity)identity)) {
                    if (userRef != null && employee == null) {
                        if (this.setError(bean, DeputyMessages.noMappingForUser(this.queryService.getName(userRef)))) {
                            bean.save();
                        }
                    } else {
                        result = this.createRoster(bean, area, employee, rosters, (Identity)identity);
                    }
                } else {
                    result = this.updateIfChanged(bean, area, userRef, employee, (Identity)identity, rosters);
                }
            } else if (this.hasSynchronised((Identity)identity) && this.setError(bean, DeputyMessages.shiftMovedToUnmappedOpenVPMSArea(name = this.queryService.getName(areaRef)))) {
                bean.save();
            }
        }
        return result;
    }

    Act synchroniseFromRoster(Roster roster, Rosters rosters) {
        Act result = null;
        Reference areaRef = this.getReferenceForDeputyId(this.areas, roster.getOperationalUnit());
        long employee = roster.getEmployee();
        Reference userRef = this.getReferenceForDeputyId(this.users, employee);
        Act event = this.queryService.getEvent(roster);
        if (event != null) {
            IMObjectBean bean = this.service.getBean((IMObject)event);
            ActIdentity identity = DeputyHelper.getSynchronisationId(bean);
            if (identity == null) {
                log.error("Cannot update event=" + event.getId() + ". Missing synchronisation identifier");
            } else {
                IMObjectBean idBean = this.service.getBean((IMObject)identity);
                if (("ERROR".equals(idBean.getString("status")) || !Objects.equals(roster.getModified(), idBean.getDate("modified"))) && this.updateEvent(roster, bean, (Identity)identity, areaRef, userRef, rosters)) {
                    result = event;
                }
            }
        } else if (areaRef != null) {
            if (employee == 0L || userRef != null) {
                Date startTime = DeputyHelper.fromUnixtimestamp(roster.getStartTime());
                Date endTime = DeputyHelper.fromUnixtimestamp(roster.getEndTime());
                result = employee != 0L ? this.syncFromEmployeeRoster(roster, areaRef, userRef, startTime, endTime) : this.syncFromOpenRoster(roster, areaRef, startTime, endTime);
            } else if (log.isInfoEnabled()) {
                log.info("Not syncing roster=" + roster.getId() + " as employee=" + roster.getEmployee() + " not mapped");
            }
        } else if (log.isInfoEnabled()) {
            log.info("Not syncing roster=" + roster.getId() + " as operational unit=" + roster.getOperationalUnit() + " not mapped");
        }
        return result;
    }

    boolean remove(Act event) {
        IMObjectBean bean = this.service.getBean((IMObject)event);
        return this.remove(bean);
    }

    boolean remove(IMObjectBean bean) {
        Target area;
        boolean result = false;
        Reference areaRef = bean.getTargetRef("schedule");
        if (areaRef != null && (area = this.areas.getTarget(areaRef)) != null) {
            long operationalUnit = DeputyHelper.getTargetId(area);
            Reference userRef = bean.getTargetRef("user");
            Target user = userRef != null ? this.users.getTarget(userRef) : null;
            long employee = DeputyHelper.getTargetId(user);
            long id = DeputyHelper.getRosterId(bean);
            if (id != -1L) {
                Roster roster = this.getRoster(id);
                if (roster != null) {
                    if (roster.getOperationalUnit() == operationalUnit && roster.getEmployee() == employee) {
                        try {
                            String response = this.deputy.removeRoster(id);
                            result = true;
                            log.info("Removed roster=" + id + " linked to deleted event=" + bean.getObject().getId() + ": " + response);
                        }
                        catch (Throwable exception) {
                            log.info("Failed to remove roster=" + id + " linked to deleted event=" + bean.getObject().getId() + ": " + exception.getMessage(), exception);
                        }
                    } else {
                        log.info("Not removing Deputy roster=" + id + " linked to deleted event=" + bean.getObject().getId() + ". The local copy had operationalUnit=" + operationalUnit + ", employee= " + employee + ", whereas Deputy has operationalUnit=" + roster.getOperationalUnit() + ", employee=" + roster.getEmployee());
                    }
                } else {
                    log.info("Not removing roster=" + id + " linked to deleted event=" + bean.getObject().getId() + " as it could not be retrieved from Deputy");
                }
            }
        }
        return result;
    }

    private Act syncFromEmployeeRoster(Roster roster, Reference areaRef, Reference userRef, Date startTime, Date endTime) {
        Act result = null;
        Act overlap = this.queryService.getOverlappingEvent(startTime, endTime, areaRef, userRef);
        if (overlap == null) {
            result = this.createEvent(roster, areaRef, userRef, startTime, endTime);
        } else {
            IMObjectBean bean = this.service.getBean((IMObject)overlap);
            ActIdentity identity = DeputyHelper.getSynchronisationId(bean);
            if (this.hasSynchronised((Identity)identity)) {
                if (this.setError(bean, DeputyMessages.syncedShiftOverlapsRoster(startTime, endTime))) {
                    bean.save();
                }
            } else if (startTime.equals(overlap.getActivityStartTime()) && endTime.equals(overlap.getActivityEndTime())) {
                this.updateSyncId(bean, (Identity)identity, roster);
                bean.save();
                result = overlap;
            } else if (this.setError(bean, DeputyMessages.unsyncedShiftOverlapsRoster(startTime, endTime))) {
                bean.save();
            }
        }
        return result;
    }

    private Act syncFromOpenRoster(Roster roster, Reference areaRef, Date startTime, Date endTime) {
        Act result = null;
        List<Act> overlaps = this.queryService.getMatchingOpenEvents(startTime, endTime, areaRef);
        if (overlaps.isEmpty()) {
            result = this.createEvent(roster, areaRef, null, startTime, endTime);
        } else {
            for (Act overlap : overlaps) {
                IMObjectBean bean = this.service.getBean((IMObject)overlap);
                ActIdentity identity = DeputyHelper.getSynchronisationId(bean);
                if (this.hasSynchronised((Identity)identity) || !startTime.equals(overlap.getActivityStartTime()) || !endTime.equals(overlap.getActivityEndTime())) continue;
                this.updateSyncId(bean, (Identity)identity, roster);
                bean.save();
                result = overlap;
                break;
            }
            if (result == null) {
                result = this.createEvent(roster, areaRef, null, startTime, endTime);
            }
        }
        return result;
    }

    private boolean hasSynchronised(Identity identity) {
        return identity != null && identity.getIdentity() != null;
    }

    private ActIdentity createIdentity(Roster roster) {
        ActIdentity identity = this.createIdentity();
        this.updateSyncId((Identity)identity, roster);
        return identity;
    }

    private void updateSyncId(IMObjectBean bean, Identity identity, Roster roster) {
        if (identity == null) {
            identity = this.createIdentity(roster);
            bean.addValue("synchronisation", (IMObject)identity);
        } else {
            this.updateSyncId(identity, roster);
        }
    }

    private void updateSyncId(Identity identity, Roster roster) {
        IMObjectBean bean = this.service.getBean((IMObject)identity);
        identity.setIdentity(Long.toString(roster.getId()));
        bean.setValue("modified", (Object)roster.getModified());
        bean.setValue("status", (Object)"SYNC");
        bean.setValue("error", null);
    }

    private void error(IMObjectBean event, Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = exception.getClass().getName() + ": No reason given";
        }
        try {
            if (this.setError(event, message)) {
                event.save();
            }
        }
        catch (Throwable throwable) {
            log.error("Failed to update event=" + event.getObject().getId() + " with error=" + message, exception);
        }
    }

    private boolean clearError(IMObjectBean event) {
        return this.setError(event, (String)null);
    }

    private boolean setError(IMObjectBean event, Message message) {
        return this.setError(event, message.toString());
    }

    private boolean setError(IMObjectBean event, String message) {
        boolean updated = false;
        String status = null;
        ActIdentity identity = DeputyHelper.getSynchronisationId(event);
        if (identity == null) {
            identity = this.createIdentity();
            event.addValue("synchronisation", (IMObject)identity);
        }
        IMObjectBean bean = this.service.getBean((IMObject)identity);
        if (message != null) {
            int maxLength = bean.getMaxLength("error");
            if (message.length() > maxLength) {
                message = message.substring(0, maxLength - 3) + "...";
            }
            status = "ERROR";
        }
        if (!Objects.equals(status, bean.getString("status"))) {
            bean.setValue("status", (Object)status);
            updated = true;
        }
        if (!Objects.equals(message, bean.getString("error"))) {
            bean.setValue("error", (Object)message);
            updated = true;
        }
        return updated;
    }

    private boolean updateEvent(Roster roster, IMObjectBean bean, Identity identity, Reference areaRef, Reference userRef, Rosters rosters) {
        boolean updated = false;
        boolean error = false;
        Date startTime = DeputyHelper.fromUnixtimestamp(roster.getStartTime());
        Date endTime = DeputyHelper.fromUnixtimestamp(roster.getEndTime());
        if (areaRef == null) {
            error = true;
            String name = this.getOperationalUnitName(roster.getOperationalUnit());
            if (this.setError(bean, DeputyMessages.shiftMovedToUnmappedDeputyArea(name))) {
                updated = true;
            }
        } else {
            if (!Objects.equals(bean.getDate("startTime"), startTime)) {
                bean.setValue("startTime", (Object)startTime);
                updated = true;
            }
            if (!Objects.equals(bean.getDate("endTime"), endTime)) {
                bean.setValue("endTime", (Object)endTime);
                updated = true;
            }
            if (userRef == null && roster.getEmployee() != 0L) {
                updated |= this.setEmployeeMappingError(bean, roster.getEmployee());
                error = true;
            } else if (!Objects.equals(userRef, bean.getTargetRef("user"))) {
                if (userRef == null) {
                    bean.removeValues("user");
                } else {
                    bean.setTarget("user", userRef);
                }
                updated = true;
            }
            if (!Objects.equals(areaRef, bean.getTargetRef("schedule"))) {
                Entity area = (Entity)this.service.get(areaRef);
                if (area == null) {
                    updated = this.setError(bean, DeputyMessages.failedToRetrieveRosterArea(areaRef));
                    error = true;
                } else {
                    Reference location = this.getLocation(area);
                    bean.setTarget("schedule", (IMObject)area);
                    bean.setTarget("location", location);
                }
            }
            if (!error) {
                updated |= this.clearError(bean);
                rosters.processed(roster);
            }
        }
        if (updated) {
            if (!error) {
                this.updateSyncId(identity, roster);
            }
            bean.save();
        }
        return updated;
    }

    private Reference getLocation(Entity area) {
        IMObjectBean bean = this.service.getBean((IMObject)area);
        return bean.getTargetRef("location");
    }

    private ActIdentity createIdentity() {
        return (ActIdentity)this.service.create("actIdentity.syncDeputyRosterId", ActIdentity.class);
    }

    private String getOperationalUnitName(long id) {
        String name = null;
        try {
            OperationalUnit unit = this.deputy.getOperationalUnit(id);
            if (unit != null) {
                name = unit.getName();
            }
        }
        catch (Throwable exception) {
            log.error("Failed to retrieve OperationalUnit with identifier=" + id + ": " + exception.getMessage(), exception);
        }
        if (name == null) {
            name = Long.toString(id);
        }
        return name;
    }

    private String getEmployeeName(long id) {
        String name = null;
        try {
            Employee employee = this.deputy.getEmployee(id);
            if (employee != null) {
                name = employee.getName();
            }
        }
        catch (Throwable exception) {
            log.error("Failed to retrieve employee with identifier=" + id + ": " + exception.getMessage(), exception);
        }
        if (name == null) {
            name = Long.toString(id);
        }
        return name;
    }

    private Roster createRoster(IMObjectBean bean, Target area, Target employee, Rosters rosters, Identity identity) {
        Roster result = null;
        RosterData data = new RosterData();
        data.setStartTime(DeputyHelper.toUnixtimestamp(bean.getDate("startTime")));
        data.setEndTime(DeputyHelper.toUnixtimestamp(bean.getDate("endTime")));
        data.setOperationalUnit(DeputyHelper.getTargetId(area));
        data.setEmployee(DeputyHelper.getTargetId(employee));
        data.setForceOverwrite(1);
        try {
            Roster created = this.deputy.roster(data);
            this.updateSyncId(bean, identity, created);
            bean.save();
            rosters.processed(created);
            result = created;
        }
        catch (Throwable exception) {
            log.error("Failed to create roster in Deputy: " + exception.getMessage(), exception);
            this.error(bean, exception);
        }
        return result;
    }

    private Act createEvent(Roster roster, Reference areaRef, Reference userRef, Date startTime, Date endTime) {
        Act result = null;
        Act act = (Act)this.service.create("act.rosterEvent", Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Entity area = (Entity)this.service.get(areaRef);
        if (area != null) {
            ActIdentity identity = this.createIdentity(roster);
            act.addIdentity(identity);
            bean.setValue("startTime", (Object)startTime);
            bean.setValue("endTime", (Object)endTime);
            bean.setTarget("schedule", areaRef);
            bean.setTarget("user", userRef);
            IMObjectBean areaBean = this.service.getBean((IMObject)area);
            Reference location = areaBean.getTargetRef("location");
            if (location != null) {
                bean.setTarget("location", location);
                bean.save();
                result = act;
            } else {
                log.error("Can't synchronise roster=" + roster.getId() + ": can't determine location with area: " + area.getObjectReference());
            }
        } else {
            log.error("Can't synchronise roster=" + roster.getId() + ": failed to retrieve area: " + areaRef);
        }
        return result;
    }

    private boolean setEmployeeMappingError(IMObjectBean bean, long employee) {
        String name = this.getEmployeeName(employee);
        return this.setError(bean, DeputyMessages.noMappingForEmployee(name));
    }

    private Roster updateIfChanged(IMObjectBean bean, Target area, Reference userRef, Target employee, Identity identity, Rosters rosters) {
        Roster current;
        Roster result = null;
        long id = DeputyHelper.getId(identity);
        Roster roster = current = id != -1L ? rosters.get(id) : null;
        if (current == null) {
            log.info("Removing event=" + bean.getObject().getId() + " linked to roster=" + id + " as roster no longer exists");
            this.service.remove(bean.getObject());
        } else if (this.deputyIsNewer(current, identity)) {
            userRef = this.getReferenceForDeputyId(this.users, current.getEmployee());
            Reference areaRef = this.getReferenceForDeputyId(this.areas, current.getOperationalUnit());
            this.updateEvent(current, bean, identity, areaRef, userRef, rosters);
            rosters.processed(current);
            result = current;
        } else if (userRef != null && employee == null) {
            if (this.setError(bean, DeputyMessages.noMappingForUser(this.queryService.getName(userRef)))) {
                bean.save();
            }
            rosters.processed(current);
        } else {
            RosterData data = this.createRosterData(current.getId(), bean, area, employee);
            if (this.isDifferent(current, data)) {
                result = this.updateRoster(data, bean, identity, rosters);
            } else {
                rosters.processed(current);
            }
        }
        return result;
    }

    private boolean deputyIsNewer(Roster current, Identity identity) {
        IMObjectBean bean = this.service.getBean((IMObject)identity);
        Date remote = current.getModified();
        Date local = bean.getDate("modified");
        if (remote == null) {
            return false;
        }
        return local == null || local.compareTo(remote) < 0;
    }

    private RosterData createRosterData(long id, IMObjectBean bean, Target area, Target user) {
        long startTime = DeputyHelper.toUnixtimestamp(bean.getDate("startTime"));
        long endTime = DeputyHelper.toUnixtimestamp(bean.getDate("endTime"));
        long operationalUnit = DeputyHelper.getTargetId(area);
        long employee = DeputyHelper.getTargetId(user);
        RosterData event = new RosterData();
        event.setId(id);
        event.setStartTime(startTime);
        event.setEndTime(endTime);
        event.setOperationalUnit(operationalUnit);
        event.setEmployee(employee);
        return event;
    }

    private Roster updateRoster(RosterData data, IMObjectBean bean, Identity identity, Rosters rosters) {
        Roster result = null;
        try {
            Roster updated = this.deputy.roster(data);
            this.updateSyncId(identity, updated);
            bean.save();
            rosters.processed(updated);
            result = updated;
        }
        catch (Throwable exception) {
            log.error("Failed to update roster in Deputy: " + exception.getMessage(), exception);
            this.error(bean, exception);
        }
        return result;
    }

    private boolean isDifferent(Roster existing, RosterData data) {
        boolean result = false;
        if (existing.getStartTime() != data.getStartTime() || existing.getEndTime() != data.getEndTime() || existing.getOperationalUnit() != data.getOperationalUnit() || existing.getEmployee() != data.getEmployee()) {
            result = true;
        }
        return result;
    }

    private Roster getRoster(long id) {
        Roster result = null;
        try {
            result = this.deputy.getRoster(id);
        }
        catch (NotFoundException exception) {
            log.info("Roster not found: " + id);
        }
        catch (Throwable exception) {
            log.info("Failed to get roster=" + id + ": " + exception.getMessage(), exception);
        }
        return result;
    }

    private Reference getReferenceForDeputyId(Mappings mappings, long id) {
        return id != 0L ? mappings.getSource(Long.toString(id)) : null;
    }
}

