/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.service;

import java.util.Date;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Path;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.deputy.internal.model.roster.Roster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryService {
    private final ArchetypeService service;
    private static final Logger log = LoggerFactory.getLogger(QueryService.class);

    QueryService(ArchetypeService service) {
        this.service = service;
    }

    List<Act> getEvents(Reference areaRef, Date from, Date to) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root root = query.from(Act.class, new String[]{"act.rosterEvent"});
        Join schedule = root.join("schedule");
        schedule.on((Expression)builder.equal((Expression)schedule.get("entity"), (Object)areaRef));
        Path startTime = root.get("startTime");
        query.where(new Predicate[]{builder.greaterThanOrEqualTo((Expression)startTime, (Comparable)from), builder.lessThan((Expression)startTime, (Comparable)to)});
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return this.service.createQuery(query).getResultList();
    }

    Act getEvent(Roster roster) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root root = query.from(Act.class, new String[]{"act.rosterEvent"});
        Join identity = root.join("synchronisation").alias("identity");
        identity.on((Expression)builder.equal((Expression)identity.get("identity"), (Object)Long.toString(roster.getId())));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        TypedQuery typedQuery = this.service.createQuery(query).setMaxResults(1);
        List acts = typedQuery.getResultList();
        return !acts.isEmpty() ? (Act)acts.get(0) : null;
    }

    Act getOverlappingEvent(Date from, Date to, Reference areaRef, Reference userRef) {
        Join user;
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root root = query.from(Act.class, new String[]{"act.rosterEvent"});
        Join schedule = root.join("schedule");
        schedule.on((Expression)builder.equal((Expression)schedule.get("entity"), (Object)areaRef));
        if (userRef != null) {
            user = root.join("user");
            user.on((Expression)builder.equal((Expression)user.get("entity"), (Object)userRef));
        } else {
            user = root.leftJoin("user");
        }
        Path startTime = root.get("startTime");
        Path endTime = root.get("endTime");
        Predicate expression = builder.or(new Predicate[]{builder.and((Expression)builder.lessThan((Expression)startTime, (Comparable)from), (Expression)builder.greaterThan((Expression)endTime, (Comparable)from)), builder.and((Expression)builder.lessThan((Expression)startTime, (Comparable)to), (Expression)builder.greaterThan((Expression)endTime, (Comparable)to)), builder.and((Expression)builder.greaterThanOrEqualTo((Expression)startTime, (Comparable)from), (Expression)builder.lessThanOrEqualTo((Expression)endTime, (Comparable)to))});
        if (userRef == null) {
            expression = builder.and((Expression)expression, (Expression)user.isNull());
        }
        query.where((Expression)expression);
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        List list = this.service.createQuery(query).setMaxResults(1).getResultList();
        return !list.isEmpty() ? (Act)list.get(0) : null;
    }

    List<Act> getMatchingOpenEvents(Date from, Date to, Reference areaRef) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root root = query.from(Act.class, new String[]{"act.rosterEvent"});
        Join schedule = root.join("schedule");
        schedule.on((Expression)builder.equal((Expression)schedule.get("entity"), (Object)areaRef));
        Join user = root.leftJoin("user");
        query.where(new Predicate[]{builder.equal((Expression)root.get("startTime"), (Object)from), builder.equal((Expression)root.get("endTime"), (Object)to), user.isNull()});
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return this.service.createQuery(query).getResultList();
    }

    String getName(Reference reference) {
        String name = null;
        try {
            IMObject object = this.service.get(reference);
            if (object != null) {
                name = object.getName();
            }
        }
        catch (Throwable exception) {
            log.error("Failed to retrieve object=" + reference, exception);
        }
        if (name == null) {
            name = Long.toString(reference.getId());
        }
        return name;
    }

    boolean isActive(Reference reference) {
        if (reference != null) {
            IMObject object = this.service.get(reference);
            return object != null && object.isActive();
        }
        return false;
    }
}

