/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import jersey.repackaged.com.google.common.base.Predicate;
import jersey.repackaged.com.google.common.collect.Collections2;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.ServiceFinderBinder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.internal.util.collection.Value;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.message.internal.HeaderValueException;
import org.glassfish.jersey.message.internal.MediaTypes;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.BackgroundSchedulerLiteral;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.spi.RequestScopedInitializer;
import org.glassfish.jersey.servlet.ServletPropertiesDelegate;
import org.glassfish.jersey.servlet.WebAppResourcesScanner;
import org.glassfish.jersey.servlet.WebConfig;
import org.glassfish.jersey.servlet.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.PersistenceUnitBinder;
import org.glassfish.jersey.servlet.internal.ResponseWriter;
import org.glassfish.jersey.servlet.internal.ServletContainerProviderFactory;
import org.glassfish.jersey.servlet.internal.Utils;
import org.glassfish.jersey.servlet.internal.spi.ExtendedServletContainerProvider;
import org.glassfish.jersey.servlet.internal.spi.RequestContextProvider;
import org.glassfish.jersey.servlet.internal.spi.RequestScopedInitializerProvider;
import org.glassfish.jersey.servlet.internal.spi.ServletContainerProvider;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegate;
import org.glassfish.jersey.servlet.spi.AsyncContextDelegateProvider;
import org.glassfish.jersey.servlet.spi.FilterUrlMappingsProvider;
import org.glassfish.jersey.uri.UriComponent;

public class WebComponent {
    private static final Logger LOGGER = Logger.getLogger(WebComponent.class.getName());
    private static final Type REQUEST_TYPE = new TypeLiteral<Ref<HttpServletRequest>>(){}.getType();
    private static final Type RESPONSE_TYPE = new TypeLiteral<Ref<HttpServletResponse>>(){}.getType();
    private static final AsyncContextDelegate DEFAULT_ASYNC_DELEGATE = new AsyncContextDelegate(){

        @Override
        public void suspend() throws IllegalStateException {
            throw new UnsupportedOperationException(LocalizationMessages.ASYNC_PROCESSING_NOT_SUPPORTED());
        }

        @Override
        public void complete() {
        }
    };
    private final RequestScopedInitializerProvider requestScopedInitializer;
    private final boolean requestResponseBindingExternalized;
    private static final RequestScopedInitializerProvider DEFAULT_REQUEST_SCOPE_INITIALIZER_PROVIDER = new RequestScopedInitializerProvider(){

        @Override
        public RequestScopedInitializer get(final RequestContextProvider context) {
            return new RequestScopedInitializer(){

                @Override
                public void initialize(ServiceLocator locator) {
                    ((Ref)locator.getService(REQUEST_TYPE, new Annotation[0])).set(context.getHttpServletRequest());
                    ((Ref)locator.getService(RESPONSE_TYPE, new Annotation[0])).set(context.getHttpServletResponse());
                }
            };
        }
    };
    final ApplicationHandler appHandler;
    final ScheduledExecutorService backgroundTaskScheduler;
    final WebConfig webConfig;
    final boolean forwardOn404;
    final boolean configSetStatusOverSendError;
    private final AsyncContextDelegateProvider asyncExtensionDelegate;
    private final boolean queryParamsAsFormParams;

    private AsyncContextDelegateProvider getAsyncExtensionDelegate() {
        Iterator<AsyncContextDelegateProvider> providers = Providers.getAllProviders(this.appHandler.getServiceLocator(), AsyncContextDelegateProvider.class).iterator();
        if (providers.hasNext()) {
            return providers.next();
        }
        return new AsyncContextDelegateProvider(){

            @Override
            public AsyncContextDelegate createDelegate(HttpServletRequest request, HttpServletResponse response) {
                return DEFAULT_ASYNC_DELEGATE;
            }
        };
    }

    public WebComponent(WebConfig webConfig, ResourceConfig resourceConfig) throws ServletException {
        this.webConfig = webConfig;
        if (resourceConfig == null) {
            resourceConfig = WebComponent.createResourceConfig(webConfig);
        }
        ServletContainerProvider[] allServletContainerProviders = ServletContainerProviderFactory.getAllServletContainerProviders();
        this.configure(resourceConfig, allServletContainerProviders);
        boolean rrbExternalized = false;
        RequestScopedInitializerProvider rsiProvider = null;
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            if (!(servletContainerProvider instanceof ExtendedServletContainerProvider)) continue;
            ExtendedServletContainerProvider extendedProvider = (ExtendedServletContainerProvider)servletContainerProvider;
            if (extendedProvider.bindsServletRequestResponse()) {
                rrbExternalized = true;
            }
            if (rsiProvider != null) continue;
            rsiProvider = extendedProvider.getRequestScopedInitializerProvider();
        }
        this.requestScopedInitializer = rsiProvider != null ? rsiProvider : DEFAULT_REQUEST_SCOPE_INITIALIZER_PROVIDER;
        this.requestResponseBindingExternalized = rrbExternalized;
        WebComponentBinder webComponentBinder = new WebComponentBinder(resourceConfig.getProperties());
        resourceConfig.register(webComponentBinder);
        ServiceLocator locator = (ServiceLocator)webConfig.getServletContext().getAttribute("jersey.config.servlet.context.serviceLocator");
        this.appHandler = new ApplicationHandler(resourceConfig, webComponentBinder, locator);
        this.asyncExtensionDelegate = this.getAsyncExtensionDelegate();
        this.forwardOn404 = webConfig.getConfigType() == WebConfig.ConfigType.FilterConfig && resourceConfig.isProperty("jersey.config.servlet.filter.forwardOn404");
        this.queryParamsAsFormParams = !resourceConfig.isProperty("jersey.config.servlet.form.queryParams.disabled");
        this.configSetStatusOverSendError = ServerProperties.getValue(resourceConfig.getProperties(), "jersey.config.server.response.setStatusOverSendError", false, Boolean.class);
        this.backgroundTaskScheduler = this.appHandler.getServiceLocator().getService(ScheduledExecutorService.class, BackgroundSchedulerLiteral.INSTANCE);
    }

    public Value<Integer> service(URI baseUri, URI requestUri, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        final ResponseWriter responseWriter = this.serviceImpl(baseUri, requestUri, servletRequest, servletResponse);
        return Values.lazy(new Value<Integer>(){

            @Override
            public Integer get() {
                return responseWriter.responseContextResolved() ? responseWriter.getResponseStatus() : -1;
            }
        });
    }

    ResponseWriter serviceImpl(URI baseUri, URI requestUri, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        ResponseWriter responseWriter = new ResponseWriter(this.forwardOn404, this.configSetStatusOverSendError, servletResponse, this.asyncExtensionDelegate.createDelegate(servletRequest, servletResponse), this.backgroundTaskScheduler);
        try {
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, servletRequest.getMethod(), WebComponent.getSecurityContext(servletRequest), new ServletPropertiesDelegate(servletRequest));
            this.initContainerRequest(requestContext, servletRequest, servletResponse, responseWriter);
            this.appHandler.handle(requestContext);
        }
        catch (HeaderValueException hve) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, LocalizationMessages.HEADER_VALUE_READ_FAILED(), hve);
            }
            Response.Status status = Response.Status.BAD_REQUEST;
            if (this.configSetStatusOverSendError) {
                servletResponse.reset();
                servletResponse.setStatus(status.getStatusCode(), status.getReasonPhrase());
            } else {
                servletResponse.sendError(status.getStatusCode(), status.getReasonPhrase());
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        return responseWriter;
    }

    private void initContainerRequest(ContainerRequest requestContext, final HttpServletRequest servletRequest, final HttpServletResponse servletResponse, ResponseWriter responseWriter) throws IOException {
        requestContext.setEntityStream((InputStream)servletRequest.getInputStream());
        requestContext.setRequestScopedInitializer(this.requestScopedInitializer.get(new RequestContextProvider(){

            @Override
            public HttpServletRequest getHttpServletRequest() {
                return servletRequest;
            }

            @Override
            public HttpServletResponse getHttpServletResponse() {
                return servletResponse;
            }
        }));
        requestContext.setWriter(responseWriter);
        this.addRequestHeaders(servletRequest, requestContext);
        this.filterFormParameters(servletRequest, requestContext);
    }

    private static SecurityContext getSecurityContext(final HttpServletRequest request) {
        return new SecurityContext(){

            @Override
            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            @Override
            public boolean isUserInRole(String role) {
                return request.isUserInRole(role);
            }

            @Override
            public boolean isSecure() {
                return request.isSecure();
            }

            @Override
            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private static ResourceConfig createResourceConfig(WebConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        ResourceConfig resourceConfig = Utils.retrieve(config.getServletContext(), config.getName());
        if (resourceConfig != null) {
            return resourceConfig;
        }
        Map<String, Object> initParams = WebComponent.getInitParams(config);
        Map<String, Object> contextParams = Utils.getContextParams(servletContext);
        String jaxrsApplicationClassName = config.getInitParameter("javax.ws.rs.Application");
        if (jaxrsApplicationClassName == null) {
            resourceConfig = new ResourceConfig().addProperties(initParams).addProperties(contextParams);
            String webApp = config.getInitParameter("jersey.config.servlet.provider.webapp");
            if (webApp != null && !"false".equals(webApp)) {
                resourceConfig.registerFinder(new WebAppResourcesScanner(servletContext));
            }
            return resourceConfig;
        }
        try {
            Class jaxrsApplicationClass = AccessController.doPrivileged(ReflectionHelper.classForNameWithExceptionPEA(jaxrsApplicationClassName));
            if (Application.class.isAssignableFrom(jaxrsApplicationClass)) {
                return ResourceConfig.forApplicationClass(jaxrsApplicationClass).addProperties(initParams).addProperties(contextParams);
            }
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_PARENT_CLASS_INVALID(jaxrsApplicationClassName, Application.class));
        }
        catch (PrivilegedActionException e) {
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_UNABLE_TO_LOAD(jaxrsApplicationClassName), e.getCause());
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(LocalizationMessages.RESOURCE_CONFIG_UNABLE_TO_LOAD(jaxrsApplicationClassName), (Throwable)e);
        }
    }

    private void configure(ResourceConfig resourceConfig, ServletContainerProvider[] allServletContainerProviders) throws ServletException {
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            servletContainerProvider.configure(resourceConfig);
        }
    }

    private void addRequestHeaders(HttpServletRequest request, ContainerRequest requestContext) {
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = request.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                if (value == null) continue;
                requestContext.header(name, value);
            }
        }
    }

    private static Map<String, Object> getInitParams(WebConfig webConfig) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        Enumeration names = webConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            props.put(name, webConfig.getInitParameter(name));
        }
        return props;
    }

    private void filterFormParameters(HttpServletRequest servletRequest, ContainerRequest containerRequest) {
        if (MediaTypes.typeEqual(MediaType.APPLICATION_FORM_URLENCODED_TYPE, containerRequest.getMediaType()) && !containerRequest.hasEntity()) {
            Form form = new Form();
            Enumeration parameterNames = servletRequest.getParameterNames();
            String queryString = servletRequest.getQueryString();
            List<String> queryParams = queryString != null ? this.getDecodedQueryParamList(queryString) : Collections.emptyList();
            boolean keepQueryParams = this.queryParamsAsFormParams || queryParams.isEmpty();
            MultivaluedMap<String, String> formMap = form.asMap();
            while (parameterNames.hasMoreElements()) {
                String name = (String)parameterNames.nextElement();
                List<String> values = Arrays.asList(servletRequest.getParameterValues(name));
                formMap.put(name, (String)((Object)(keepQueryParams ? values : this.filterQueryParams(name, values, queryParams))));
            }
            if (!formMap.isEmpty()) {
                containerRequest.setProperty("jersey.config.server.representation.decoded.form", form);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.FORM_PARAM_CONSUMED(containerRequest.getRequestUri()));
                }
            }
        }
    }

    private List<String> getDecodedQueryParamList(String queryString) {
        ArrayList<String> params = new ArrayList<String>();
        for (String param : queryString.split("&")) {
            params.add(UriComponent.decode(param, UriComponent.Type.QUERY_PARAM));
        }
        return params;
    }

    private List<String> filterQueryParams(final String name, List<String> values, final Collection<String> params) {
        return new ArrayList<String>(Collections2.filter(values, new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return !params.remove(name + "=" + input) && !params.remove(name + "[]=" + input);
            }
        }));
    }

    public ApplicationHandler getAppHandler() {
        return this.appHandler;
    }

    private final class WebComponentBinder
    extends AbstractBinder {
        private final Map<String, Object> applicationProperties;

        private WebComponentBinder(Map<String, Object> applicationProperties) {
            this.applicationProperties = applicationProperties;
        }

        @Override
        protected void configure() {
            if (!WebComponent.this.requestResponseBindingExternalized) {
                this.bindFactory(HttpServletRequestReferencingFactory.class).to(HttpServletRequest.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
                this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<HttpServletRequest>>(){}).in(RequestScoped.class);
                this.bindFactory(HttpServletResponseReferencingFactory.class).to(HttpServletResponse.class).proxy(true).proxyForSameScope(false).in(RequestScoped.class);
                this.bindFactory(ReferencingFactory.referenceFactory()).to(new TypeLiteral<Ref<HttpServletResponse>>(){}).in(RequestScoped.class);
            }
            this.bindFactory(new Factory<ServletContext>(){

                @Override
                public ServletContext provide() {
                    return WebComponent.this.webConfig.getServletContext();
                }

                @Override
                public void dispose(ServletContext instance) {
                }
            }).to(ServletContext.class).in(Singleton.class);
            final ServletConfig servletConfig = WebComponent.this.webConfig.getServletConfig();
            if (WebComponent.this.webConfig.getConfigType() == WebConfig.ConfigType.ServletConfig) {
                this.bindFactory(new Factory<ServletConfig>(){

                    @Override
                    public ServletConfig provide() {
                        return servletConfig;
                    }

                    @Override
                    public void dispose(ServletConfig instance) {
                    }
                }).to(ServletConfig.class).in(Singleton.class);
                Enumeration initParams = servletConfig.getInitParameterNames();
                while (initParams.hasMoreElements()) {
                    String initParamName = (String)initParams.nextElement();
                    if (!initParamName.startsWith("unit:")) continue;
                    this.install(new PersistenceUnitBinder());
                    break;
                }
            } else {
                this.bindFactory(new Factory<FilterConfig>(){

                    @Override
                    public FilterConfig provide() {
                        return WebComponent.this.webConfig.getFilterConfig();
                    }

                    @Override
                    public void dispose(FilterConfig instance) {
                    }
                }).to(FilterConfig.class).in(Singleton.class);
            }
            this.bindFactory(new Factory<WebConfig>(){

                @Override
                public WebConfig provide() {
                    return WebComponent.this.webConfig;
                }

                @Override
                public void dispose(WebConfig instance) {
                }
            }).to(WebConfig.class).in(Singleton.class);
            this.install(new ServiceFinderBinder<AsyncContextDelegateProvider>(AsyncContextDelegateProvider.class, this.applicationProperties, RuntimeType.SERVER));
            this.install(new ServiceFinderBinder<FilterUrlMappingsProvider>(FilterUrlMappingsProvider.class, this.applicationProperties, RuntimeType.SERVER));
        }
    }

    private static class HttpServletResponseReferencingFactory
    extends ReferencingFactory<HttpServletResponse> {
        @Inject
        public HttpServletResponseReferencingFactory(Provider<Ref<HttpServletResponse>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class HttpServletRequestReferencingFactory
    extends ReferencingFactory<HttpServletRequest> {
        @Inject
        public HttpServletRequestReferencingFactory(Provider<Ref<HttpServletRequest>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

