/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.service;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.deputy.internal.api.Deputy;
import org.openvpms.deputy.internal.i18n.DeputyMessages;
import org.openvpms.deputy.internal.mapping.Employees;
import org.openvpms.deputy.internal.mapping.OperationalUnits;
import org.openvpms.deputy.internal.model.organisation.Company;
import org.openvpms.deputy.internal.model.organisation.Employee;
import org.openvpms.deputy.internal.model.organisation.OperationalUnit;
import org.openvpms.deputy.internal.model.query.Query;
import org.openvpms.deputy.internal.model.roster.Roster;
import org.openvpms.deputy.internal.model.roster.RosterData;
import org.openvpms.deputy.internal.service.DeputyClient;
import org.openvpms.deputy.internal.service.DeputyHelper;
import org.openvpms.deputy.internal.service.QueryService;
import org.openvpms.deputy.internal.service.RosterSynchroniser;
import org.openvpms.deputy.internal.service.SynchronisationManager;
import org.openvpms.mapping.exception.MappingException;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Targets;
import org.openvpms.mapping.service.MappingProvider;
import org.openvpms.mapping.service.MappingService;
import org.openvpms.plugin.service.archetype.ArchetypeInstaller;
import org.openvpms.plugin.service.util.ContextClassLoaderHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeputyServiceImpl
implements MappingProvider,
Deputy {
    public static final String NAME = "Deputy Roster Synchronisation Service";
    private final ArchetypeService service;
    private final MappingService mappingService;
    private final PasswordEncryptor encryptor;
    private final QueryService queryService;
    private final ScheduledExecutorService executor;
    private final AtomicLong counter = new AtomicLong(0L);
    private volatile boolean syncInProgress = false;
    private SynchronisationManager synchroniser;
    private Deputy client;
    private String url;
    private String accessToken;
    private int daysToSync;
    private int syncFrequency;
    private IMObject mapping;
    private ScheduledFuture<?> future;
    private static final Logger log = LoggerFactory.getLogger(DeputyServiceImpl.class);

    public DeputyServiceImpl(ArchetypeService service, ArchetypeInstaller installer, MappingService mappingService, PasswordEncryptor encryptor) {
        this.install(installer, "entity.pluginDeputy");
        this.install(installer, "actIdentity.syncDeputyRosterId");
        this.service = service;
        this.mappingService = mappingService;
        this.encryptor = encryptor;
        this.queryService = new QueryService(service);
        this.executor = Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, "DeputySync" + this.counter.incrementAndGet()));
    }

    public String getName() {
        return NAME;
    }

    public List<Mappings<?>> getMappings() {
        return Arrays.asList(this.getRosterAreas(), this.getUsers());
    }

    public synchronized void setConfiguration(IMObject config) {
        try {
            this.stopSync();
            if (config != null) {
                IMObjectBean bean = this.service.getBean(config);
                this.url = bean.getString("url");
                this.accessToken = this.getAccessToken(bean);
                this.mapping = bean.getTarget("mapping");
                this.daysToSync = bean.getInt("daysToSync");
                if (this.daysToSync < 1) {
                    this.daysToSync = 30;
                }
                this.syncFrequency = bean.getInt("syncFrequency");
                if (this.syncFrequency < 5) {
                    this.syncFrequency = 5;
                }
                if (this.mapping == null) {
                    this.mapping = this.mappingService.createMappingConfiguration(Entity.class);
                    bean.addTarget("mapping", this.mapping);
                    bean.save(new IMObject[]{this.mapping});
                }
            } else {
                this.url = null;
                this.accessToken = null;
                this.mapping = null;
            }
            this.client = null;
            if (this.mapping != null && this.accessToken != null) {
                this.startSynchronisation();
            }
        }
        catch (Throwable exception) {
            log.error("Failed to update configuration", exception);
        }
    }

    public synchronized void dispose() {
        this.stopSync();
    }

    @Override
    public List<Company> getCompanies() {
        return this.getClient().getCompanies();
    }

    @Override
    public List<OperationalUnit> getOperationalUnits(Query query) {
        return this.getClient().getOperationalUnits(query);
    }

    @Override
    public OperationalUnit getOperationalUnit(long id) {
        return this.getClient().getOperationalUnit(id);
    }

    @Override
    public List<Employee> getEmployees(Query query) {
        return this.getClient().getEmployees(query);
    }

    @Override
    public Employee getEmployee(long id) {
        return this.getClient().getEmployee(id);
    }

    @Override
    public List<Roster> getRosters(Query query) {
        return this.getClient().getRosters(query);
    }

    @Override
    public Roster getRoster(long id) {
        return this.getClient().getRoster(id);
    }

    @Override
    public String removeRoster(long id) {
        return this.getClient().removeRoster(id);
    }

    @Override
    public Roster roster(RosterData data) {
        return this.getClient().roster(data);
    }

    public void eventUpdated(Act event) {
        if (!this.syncInProgress) {
            try {
                if (this.isCurrent(event)) {
                    IMObjectBean bean = this.service.getBean((IMObject)event);
                    ActIdentity identity = DeputyHelper.getSynchronisationId(bean);
                    if (identity == null || "PENDING".equals(this.service.getBean((IMObject)identity).getValue("status"))) {
                        RosterSynchroniser updater = new RosterSynchroniser(this.getRosterAreas(), this.getUsers(), this, this.queryService, this.service);
                        updater.synchroniseFromEvent(bean);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Ignoring update of event=" + event.getObjectReference() + ". Shift ended before today");
                }
            }
            catch (Throwable exception) {
                log.error("Failed to update event=" + event.getId() + ": " + exception.getMessage(), exception);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Ignoring update of event=" + event.getObjectReference() + " during synchronisation");
        }
    }

    public void eventRemoved(Act event) {
        if (!this.syncInProgress) {
            try {
                if (this.isCurrent(event)) {
                    IMObjectBean bean = this.service.getBean((IMObject)event);
                    ActIdentity identity = DeputyHelper.getSynchronisationId(bean);
                    if (identity != null) {
                        RosterSynchroniser updater = new RosterSynchroniser(this.getRosterAreas(), this.getUsers(), this, this.queryService, this.service);
                        updater.remove(bean);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Ignoring removal of event=" + event.getObjectReference() + ". Shift ended before today");
                }
            }
            catch (Throwable exception) {
                log.error("Failed to remove event=" + event.getId() + ": " + exception.getMessage(), exception);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("Ignoring removal of event=" + event.getObjectReference() + " during synchronisation");
        }
    }

    protected String getAccessToken(IMObjectBean bean) {
        String result = null;
        String accessToken = bean.getString("accessToken");
        if (accessToken != null) {
            try {
                result = this.encryptor.decrypt(accessToken);
            }
            catch (Throwable exception) {
                log.error("Failed to decrypt accessToken. Calls to Deputy will not succeed: " + exception.getMessage(), exception);
            }
        }
        return result;
    }

    private boolean isCurrent(Act event) {
        LocalDate today = LocalDate.now();
        LocalDate date = event.getActivityEndTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return !date.isBefore(today);
    }

    private Mappings<Entity> getRosterAreas() {
        OperationalUnits targets = new OperationalUnits("Deputy Area", this);
        return this.mappingService.createMappings(this.getMapping(), Entity.class, "entity.rosterArea", "Roster Areas", (Targets)targets);
    }

    private Mappings<User> getUsers() {
        Employees targets = new Employees("Deputy Employee", this);
        return this.mappingService.createMappings(this.getMapping(), User.class, "security.user", "Employees", (Targets)targets);
    }

    private void startSynchronisation() {
        this.stopSync();
        this.future = this.executor.scheduleAtFixedRate(this::sync, 0L, this.syncFrequency, TimeUnit.MINUTES);
    }

    private synchronized void stopSync() {
        if (this.synchroniser != null) {
            this.synchroniser.stop();
            this.synchroniser = null;
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sync() {
        try {
            SynchronisationManager sync;
            DeputyServiceImpl deputyServiceImpl = this;
            synchronized (deputyServiceImpl) {
                int days = this.daysToSync;
                if (log.isInfoEnabled()) {
                    log.info("Synchronising with Deputy, daysToSync=" + days + ", syncFrequency=" + this.syncFrequency);
                }
                this.synchroniser = sync = new SynchronisationManager(days, this.getRosterAreas(), this.getUsers(), this, this.queryService, this.service);
                this.syncInProgress = true;
            }
            sync.run();
        }
        catch (Throwable exception) {
            log.error("Synchronisation with Deputy failed", exception);
        }
        finally {
            this.syncInProgress = false;
        }
    }

    private synchronized IMObject getMapping() {
        if (this.mapping == null) {
            throw new MappingException(DeputyMessages.notConfigured());
        }
        return this.mapping;
    }

    private void install(ArchetypeInstaller installer, String archetype) {
        installer.install(this.getClass(), "/org/openvpms/deputy/internal/archetype/" + archetype + ".adl");
    }

    private synchronized Deputy getClient() {
        if (this.client == null) {
            try {
                this.client = (Deputy)ContextClassLoaderHelper.proxy(() -> new DeputyClient(this.url, this.accessToken));
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IllegalStateException("Failed to create Deputy client: " + exception.getMessage(), exception);
            }
        }
        return this.client;
    }
}

