/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.openvpms.deputy.internal.api.Deputy;
import org.openvpms.deputy.internal.api.ResponseError;
import org.openvpms.deputy.internal.model.organisation.Company;
import org.openvpms.deputy.internal.model.organisation.Employee;
import org.openvpms.deputy.internal.model.organisation.OperationalUnit;
import org.openvpms.deputy.internal.model.query.Query;
import org.openvpms.deputy.internal.model.roster.Roster;
import org.openvpms.deputy.internal.model.roster.RosterData;
import org.openvpms.ws.util.ErrorResponseFilter;
import org.openvpms.ws.util.ObjectMapperContextResolver;
import org.openvpms.ws.util.SLF4JLoggingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DeputyClient
implements Deputy {
    private Deputy client;
    private static final Form EMPTY_FORM = new Form();
    private static final Logger log = LoggerFactory.getLogger(DeputyClient.class);
    private static final int TIMEOUT = 30000;
    private static final String AUTHORIZATION = "Authorization";

    DeputyClient(String url, String accessToken) {
        url = StringUtils.removeEnd((String)url, (String)"/");
        ObjectMapperContextResolver resolver = new ObjectMapperContextResolver(TimeZone.getDefault(), "yyyy-MM-dd'T'HH:mm:ssXXX");
        ClientConfig config = ((ClientConfig)new ClientConfig().register(resolver).register((Class)JacksonFeature.class)).register(new ErrorResponseFilter((ObjectMapper)resolver.getContext((Class)Object.class), ResponseError.class)).register(new SLF4JLoggingFeature(log, AUTHORIZATION));
        Client client = ClientBuilder.newClient(config);
        client.property("jersey.config.client.connectTimeout", 30000);
        client.property("jersey.config.client.readTimeout", 30000);
        MultivaluedHashMap<String, Object> headers = new MultivaluedHashMap<String, Object>();
        headers.add(AUTHORIZATION, "OAuth " + accessToken);
        headers.add("dp-meta-option", "none");
        WebTarget target = client.target(url);
        this.client = WebResourceFactory.newResource(Deputy.class, target, false, headers, Collections.emptyList(), EMPTY_FORM);
    }

    @Override
    public List<Company> getCompanies() {
        return this.client.getCompanies();
    }

    @Override
    public List<OperationalUnit> getOperationalUnits(Query query) {
        return this.client.getOperationalUnits(query);
    }

    @Override
    public OperationalUnit getOperationalUnit(long id) {
        return this.client.getOperationalUnit(id);
    }

    @Override
    public List<Employee> getEmployees(Query query) {
        return this.client.getEmployees(query);
    }

    @Override
    public Employee getEmployee(long id) {
        return this.client.getEmployee(id);
    }

    @Override
    public List<Roster> getRosters(Query query) {
        return this.client.getRosters(query);
    }

    @Override
    public Roster getRoster(long id) {
        return this.client.getRoster(id);
    }

    @Override
    public Roster roster(RosterData data) {
        return this.client.roster(data);
    }

    @Override
    public String removeRoster(long id) {
        return this.client.removeRoster(id);
    }
}

