/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.service;

import java.util.List;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.deputy.internal.service.DeputyServiceImpl;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.service.MappingProvider;
import org.openvpms.mapping.service.MappingService;
import org.openvpms.plugin.service.archetype.ArchetypeInstaller;
import org.openvpms.plugin.service.archetype.IMObjectListener;
import org.openvpms.plugin.service.config.ConfigurableService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MappingProvider.class, ConfigurableService.class, IMObjectListener.class}, immediate=true)
public class DeputyService
implements MappingProvider,
ConfigurableService,
IMObjectListener {
    private DeputyServiceImpl deputyService;
    private ArchetypeService service;
    private ArchetypeInstaller installer;
    private MappingService mappingService;
    private PasswordEncryptor encryptor;
    private IMObject config;
    private static final Logger log = LoggerFactory.getLogger(DeputyService.class);

    public String getName() {
        return "Deputy Roster Synchronisation Service";
    }

    public String getArchetype() {
        return "entity.pluginDeputy";
    }

    public List<Mappings<?>> getMappings() {
        return this.getDeputyService().getMappings();
    }

    public synchronized void setConfiguration(IMObject config) {
        this.config = config;
        if (this.deputyService != null) {
            this.deputyService.setConfiguration(config);
        }
    }

    public synchronized IMObject getConfiguration() {
        return this.config;
    }

    @Reference
    public synchronized void setArchetypeService(ArchetypeService service) {
        this.service = service;
    }

    @Reference
    public synchronized void setArchetypeInstaller(ArchetypeInstaller installer) {
        this.installer = installer;
    }

    @Reference
    public synchronized void setMappingService(MappingService mappingService) {
        this.mappingService = mappingService;
    }

    @Reference
    public synchronized void setEncryptor(PasswordEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public String[] getArchetypes() {
        return new String[]{"act.rosterEvent"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(IMObject object) {
        if (object instanceof Act) {
            DeputyServiceImpl service;
            DeputyService deputyService = this;
            synchronized (deputyService) {
                service = this.deputyService;
            }
            if (service != null) {
                service.eventUpdated((Act)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removed(IMObject object) {
        if (object instanceof Act) {
            DeputyServiceImpl service;
            DeputyService deputyService = this;
            synchronized (deputyService) {
                service = this.deputyService;
            }
            if (service != null) {
                service.eventRemoved((Act)object);
            }
        }
    }

    @Activate
    public synchronized void activate() {
        try {
            if (this.deputyService != null) {
                this.deputyService.dispose();
            }
            this.deputyService = new DeputyServiceImpl(this.service, this.installer, this.mappingService, this.encryptor);
            this.deputyService.setConfiguration(this.config);
        }
        catch (Throwable exception) {
            log.error("Failed to activate DeputyService", exception);
            throw exception;
        }
    }

    @Deactivate
    public synchronized void deactivate() {
        if (this.deputyService != null) {
            try {
                this.deputyService.dispose();
            }
            catch (Throwable exception) {
                log.error("Failed to destroy the DeputyService", exception);
            }
            this.deputyService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeputyServiceImpl getDeputyService() {
        DeputyServiceImpl result;
        DeputyService deputyService = this;
        synchronized (deputyService) {
            result = this.deputyService;
        }
        if (result == null) {
            throw new IllegalStateException("Deputy service not configured");
        }
        return result;
    }
}

