/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.model.query;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import org.openvpms.deputy.internal.model.query.Field;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Query {
    @JsonProperty(value="search")
    private Map<String, Field> search;
    @JsonProperty(value="sort")
    private Map<String, String> sort;
    @JsonProperty(value="start")
    private Integer firstResults;
    @JsonProperty(value="max")
    private Integer maxResults;

    public Map<String, Field> getSearch() {
        return this.search;
    }

    public void addSearch(String name, Field field) {
        if (this.search == null) {
            this.search = new LinkedHashMap<String, Field>();
        }
        this.search.put(name, field);
    }

    public void addSearch(String name, String field, String type, Object data) {
        this.addSearch(name, new Field(field, type, data));
    }

    public Map<String, String> getSort() {
        return this.sort;
    }

    public void orderBy(String name, boolean ascending) {
        this.addSort(name, ascending ? "asc" : "desc");
    }

    public Integer getFirstResults() {
        return this.firstResults;
    }

    public void setFirstResult(Integer firstResult) {
        this.firstResults = firstResult;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    private void addSort(String name, String order) {
        if (this.sort == null) {
            this.sort = new LinkedHashMap<String, String>();
        }
        this.sort.put(name, order);
    }
}

