/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.mapping;

import java.util.List;
import org.openvpms.deputy.internal.api.Deputy;
import org.openvpms.deputy.internal.mapping.DeputyTargets;
import org.openvpms.deputy.internal.model.organisation.Employee;
import org.openvpms.deputy.internal.model.query.Query;
import org.openvpms.deputy.internal.service.QueryHelper;
import org.openvpms.mapping.model.DefaultTarget;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Employees
extends DeputyTargets {
    private final Deputy deputyService;
    private static final Logger log = LoggerFactory.getLogger(Employees.class);

    public Employees(String displayName, Deputy deputyService) {
        super(displayName);
        this.deputyService = deputyService;
    }

    public Target getTarget(String identity) {
        DefaultTarget result = null;
        try {
            Employee unit = this.deputyService.getEmployee(Long.valueOf(identity));
            result = new DefaultTarget(identity, unit.getName(), unit.getActive());
        }
        catch (Throwable exception) {
            log.error("Failed to get Employee=" + identity + ": " + exception.getMessage(), exception);
        }
        return result;
    }

    public List<Target> getTargets(Mappings mappings, String name, boolean unmapped, int firstResult, int maxResults) {
        Query query = new Query();
        query.orderBy("DisplayName", true);
        query.orderBy("Id", true);
        List employees = QueryHelper.query(query, this.deputyService::getEmployees);
        return this.getTargets(mappings, name, unmapped, firstResult, maxResults, employees);
    }
}

