/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.ws.util.filter;

import java.io.StringReader;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.openvpms.ws.util.MediaTypes;
import org.openvpms.ws.util.filter.AbstractSerialisedErrorMessageReader;

public class JAXBErrorMessageReader<T>
extends AbstractSerialisedErrorMessageReader<T> {
    private final JAXBContext context;

    public JAXBErrorMessageReader(Class<T> type) throws JAXBException {
        this(JAXBContext.newInstance((Class[])new Class[]{type}), type);
    }

    public JAXBErrorMessageReader(JAXBContext context, Class<T> type) {
        super(type);
        this.context = context;
    }

    @Override
    public boolean canRead(ClientResponseContext response) {
        return MediaTypes.isA(this.getMediaType(response), MediaType.APPLICATION_XML_TYPE, MediaType.TEXT_XML_TYPE);
    }

    @Override
    protected T deserialise(String value, Class<T> type) throws JAXBException {
        StreamSource source = new StreamSource(new StringReader(value));
        JAXBElement element = this.context.createUnmarshaller().unmarshal((Source)source, type);
        return (T)(element != null ? element.getValue() : null);
    }
}

