/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import org.openvpms.deputy.internal.api.Deputy;
import org.openvpms.deputy.internal.model.roster.Roster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Rosters {
    private final Deputy deputy;
    private final Map<Long, Roster> rosters = new LinkedHashMap<Long, Roster>();
    private Set<Long> processed = new HashSet<Long>();
    private static final Logger log = LoggerFactory.getLogger(Rosters.class);

    Rosters(Deputy deputy) {
        this.deputy = deputy;
    }

    Rosters(List<Roster> rosters, Deputy deputy) {
        this.deputy = deputy;
        for (Roster roster : rosters) {
            this.add(roster);
        }
    }

    void processed(Roster roster) {
        this.add(roster);
        this.processed.add(roster.getId());
    }

    Roster get(long id) {
        Roster result = null;
        if (id != -1L && (result = this.rosters.get(id)) == null) {
            try {
                result = this.deputy.getRoster(id);
                if (result != null) {
                    this.add(result);
                }
            }
            catch (NotFoundException exception) {
                log.debug("Roster not found: " + id, (Throwable)exception);
            }
        }
        return result;
    }

    List<Roster> getUnprocessed() {
        ArrayList<Roster> result = new ArrayList<Roster>();
        for (Roster roster : this.rosters.values()) {
            if (this.processed.contains(roster.getId())) continue;
            result.add(roster);
        }
        return result;
    }

    private void add(Roster roster) {
        this.rosters.put(roster.getId(), roster);
    }
}

