/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.mapping;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.deputy.internal.model.organisation.Resource;
import org.openvpms.mapping.model.DefaultTarget;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Target;
import org.openvpms.mapping.model.Targets;

public abstract class DeputyTargets
implements Targets {
    private final String displayName;

    DeputyTargets(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int count(Mappings mappings, String name, boolean unmapped) {
        int first = 0;
        int max = 500;
        int result = 0;
        boolean done = false;
        while (!done) {
            List targets = this.getTargets(mappings, name, unmapped, first, max);
            int size = targets.size();
            result += size;
            if (size < max) {
                done = true;
            }
            first += max;
        }
        return result;
    }

    public Target create(String identity, String name, boolean active) {
        return new DefaultTarget(identity, name, active);
    }

    List<Target> getTargets(Mappings mappings, String name, boolean unmapped, int firstResult, int maxResults, List<? extends Resource> objects) {
        ArrayList<Target> result = new ArrayList<Target>();
        name = name != null ? name.toLowerCase() : null;
        int matches = 0;
        for (int i = 0; i < objects.size() && (maxResults == -1 || result.size() < maxResults); ++i) {
            Resource object = objects.get(i);
            if (unmapped && !this.isUnmapped(mappings, object.getId())) continue;
            String objectName = object.getName();
            if (name != null && (objectName == null || !objectName.toLowerCase().contains(name))) continue;
            if (matches >= firstResult) {
                DefaultTarget target = new DefaultTarget(object.getId(), objectName, object.getActive());
                result.add((Target)target);
            }
            ++matches;
        }
        return result;
    }

    private boolean isUnmapped(Mappings mappings, long target) {
        return mappings.getMapping(Long.toString(target)) == null;
    }
}

