/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.deputy.internal.service;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.openvpms.deputy.internal.model.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    public static final int MAX_RESULTS = 500;
    private static final Logger log = LoggerFactory.getLogger(QueryHelper.class);

    public static <T> List<T> query(Query query, Function<Query, List<T>> function) {
        return QueryHelper.query(query, 500, function, null);
    }

    public static <T> List<T> query(Query query, int pageSize, Function<Query, List<T>> function, AtomicBoolean stop) {
        ArrayList<T> results = new ArrayList<T>();
        int firstResult = 0;
        query.setMaxResults(pageSize);
        boolean done = false;
        while (!(done || stop != null && stop.get())) {
            query.setFirstResult(firstResult);
            List<T> matches = function.apply(query);
            if (matches.size() < pageSize) {
                done = true;
            } else {
                if (matches.size() > pageSize) {
                    log.error("Returned " + matches.size() + ", requested=" + pageSize);
                }
                firstResult += matches.size();
            }
            results.addAll(matches);
        }
        return results;
    }
}

