/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.media.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.ws.rs.ext.ContextResolver;
import org.glassfish.jersey.internal.util.PropertiesClass;
import org.glassfish.jersey.message.internal.ReaderWriter;

@PropertiesClass
public class MultiPartProperties {
    public static final int DEFAULT_BUFFER_THRESHOLD = ReaderWriter.BUFFER_SIZE;
    public static final String MULTI_PART_CONFIG_RESOURCE = "jersey-multipart-config.properties";
    public static final String BUFFER_THRESHOLD = "jersey.config.multipart.bufferThreshold";
    public static final int BUFFER_THRESHOLD_MEMORY_ONLY = -1;
    public static final String MAX_PARTS = "jersey.config.multipart.maxParts";
    public static final String TEMP_DIRECTORY = "jersey.config.multipart.tempDir";
    private int bufferThreshold = DEFAULT_BUFFER_THRESHOLD;
    private String tempDir = null;
    private int maxParts = Integer.MAX_VALUE;

    public MultiPartProperties() {
        this.configure();
    }

    public int getBufferThreshold() {
        return this.bufferThreshold;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public int getMaxParts() {
        return this.maxParts;
    }

    public MultiPartProperties bufferThreshold(int threshold) {
        this.bufferThreshold = threshold < -1 ? -1 : threshold;
        return this;
    }

    public MultiPartProperties tempDir(String path) {
        this.tempDir = path;
        return this;
    }

    public MultiPartProperties maxParts(int maxParts) {
        this.maxParts = maxParts;
        return this;
    }

    private void configure() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        InputStream stream = null;
        try {
            stream = loader.getResourceAsStream(MULTI_PART_CONFIG_RESOURCE);
            if (stream == null) {
                return;
            }
            Properties props = new Properties();
            props.load(stream);
            if (props.containsKey(BUFFER_THRESHOLD)) {
                this.bufferThreshold = Integer.parseInt(props.getProperty(BUFFER_THRESHOLD));
            }
            if (props.containsKey(TEMP_DIRECTORY)) {
                this.tempDir = props.getProperty(TEMP_DIRECTORY);
            }
            if (props.contains(MAX_PARTS)) {
                this.maxParts = Integer.parseInt(props.getProperty(MAX_PARTS));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public ContextResolver<MultiPartProperties> resolver() {
        return new ContextResolver<MultiPartProperties>(){

            @Override
            public MultiPartProperties getContext(Class<?> type) {
                return MultiPartProperties.this;
            }
        };
    }
}

