/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.clickatell.service;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.List;
import javax.ws.rs.BadRequestException;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.clickatell.internal.api.Clickatell;
import org.openvpms.clickatell.internal.client.ErrorHelper;
import org.openvpms.clickatell.internal.i18n.ClickatellMessages;
import org.openvpms.clickatell.internal.model.SMS;
import org.openvpms.clickatell.internal.model.SMSResponse;
import org.openvpms.clickatell.internal.model.SMSResponses;
import org.openvpms.clickatell.internal.service.ClickatellFactory;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.sms.exception.SMSException;
import org.openvpms.sms.message.OutboundMessage;
import org.openvpms.sms.service.SMSProvider;

public class ClickatellProvider
implements SMSProvider {
    private final ArchetypeService service;
    private final ClickatellFactory factory;

    public ClickatellProvider(ArchetypeService service, ClickatellFactory factory) {
        this.service = service;
        this.factory = factory;
    }

    public String getName() {
        return "Clickatell SMS Provider";
    }

    public String[] getArchetypes() {
        return new String[]{"entity.smsProviderClickatell"};
    }

    public void send(OutboundMessage message, Entity config) {
        int validityPeriod = this.getValidityPeriod(message);
        if (validityPeriod == 0) {
            message.setStatus(OutboundMessage.Status.EXPIRED);
        } else {
            IMObjectBean bean = this.service.getBean((IMObject)config);
            SMS msg = this.createSMS(message, validityPeriod, bean);
            try {
                Clickatell client = this.factory.create(bean);
                SMSResponses responses = client.send(msg);
                List<SMSResponse> list = responses.getMessages();
                if (list.isEmpty()) {
                    throw new SMSException(ClickatellMessages.errorSendingMessage(responses.getErrorCode(), responses.getError(), responses.getErrorDescription()));
                }
                SMSResponse response = list.get(0);
                if (response.getAccepted() != null && response.getAccepted().booleanValue()) {
                    message.state().providerId("actIdentity.smsClickatell", response.getApiMessageId()).status(OutboundMessage.Status.SENT).build();
                } else {
                    message.setStatus(OutboundMessage.Status.ERROR, ErrorHelper.formatError(response));
                }
            }
            catch (BadRequestException exception) {
                message.setStatus(OutboundMessage.Status.ERROR, exception.getMessage());
            }
            catch (SMSException exception) {
                throw exception;
            }
            catch (Throwable exception) {
                throw new SMSException(ClickatellMessages.exceptionSendingMessage(exception), exception);
            }
        }
    }

    protected SMS createSMS(OutboundMessage message, int validityPeriod, IMObjectBean bean) {
        SMS msg = new SMS();
        String phone = message.getPhone();
        String countryPrefix = bean.getString("countryPrefix");
        String areaPrefix = bean.getString("areaPrefix");
        phone = this.getPhone(phone, countryPrefix, areaPrefix);
        msg.setFrom(this.getPhone(bean.getString("from"), countryPrefix, areaPrefix));
        msg.setTo(phone);
        msg.setContent(message.getMessage());
        msg.setClientMessageId(Long.toString(message.getId()));
        if (validityPeriod > 0) {
            msg.setValidityPeriod(validityPeriod);
        }
        return msg;
    }

    private int getValidityPeriod(OutboundMessage message) {
        int result = -1;
        OffsetDateTime expiry = message.getExpiry();
        if (expiry != null) {
            OffsetDateTime now = OffsetDateTime.now();
            long minutes = 0L;
            if (now.isBefore(expiry)) {
                minutes = Duration.between(now, expiry).toMinutes();
            }
            if (minutes == 0L) {
                result = 0;
            } else if (minutes <= Integer.MAX_VALUE) {
                result = (int)minutes;
            }
        }
        return result;
    }

    private String getPhone(String phone, String countryPrefix, String areaPrefix) {
        if ((phone = StringUtils.trimToNull((String)phone)) != null) {
            if (phone.startsWith("+")) {
                phone = phone.substring(1);
            } else if (countryPrefix != null && !phone.startsWith(countryPrefix)) {
                if (areaPrefix != null && phone.startsWith(areaPrefix)) {
                    phone = phone.substring(areaPrefix.length());
                }
                phone = countryPrefix + phone;
            }
        }
        return phone;
    }
}

