/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.clickatell.internal.service;

import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.NotFoundException;
import org.apache.commons.lang3.time.StopWatch;
import org.openvpms.clickatell.internal.api.Clickatell;
import org.openvpms.clickatell.internal.model.SMSStatus;
import org.openvpms.sms.message.Messages;
import org.openvpms.sms.message.OutboundMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStatusUpdater {
    private final Clickatell clickatell;
    private final Messages messages;
    private final OffsetDateTime from;
    private volatile boolean stop;
    public static final String RECEIVED_BY_RECIPIENT = "RECEIVED_BY_RECIPIENT";
    public static final String EXPIRED = "EXPIRED";
    public static final String DELIVERED_TO_GATEWAY = "DELIVERED_TO_GATEWAY";
    public static final String ERROR_DELIVERING = "ERROR_DELIVERING";
    private static final Logger log = LoggerFactory.getLogger(MessageStatusUpdater.class);

    public MessageStatusUpdater(Clickatell clickatell, Messages messages, OffsetDateTime from) {
        this.clickatell = clickatell;
        this.messages = messages;
        this.from = from;
    }

    public int update() {
        HashSet<Long> seen = new HashSet<Long>();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int passes = 0;
        int updated = 0;
        try {
            while (!this.stop) {
                ++passes;
                int changed = this.update(seen);
                if (changed != 0) {
                    updated += changed;
                    continue;
                }
                break;
            }
        }
        catch (Throwable exception) {
            log.error("Failed to update SMS message statuses: {}", (Object)exception.getMessage(), (Object)exception);
        }
        stopWatch.stop();
        log.debug("Processed={}, updated={}, passes={} in {}", new Object[]{seen.size(), updated, passes, stopWatch});
        return updated;
    }

    public void stop() {
        this.stop = true;
    }

    protected int update(Set<Long> seen) {
        int updated = 0;
        Iterable sent = this.messages.getSent(this.from, "actIdentity.smsClickatell");
        for (OutboundMessage message : sent) {
            if (this.stop) break;
            if (!seen.add(message.getId())) continue;
            try {
                if (!this.update(message)) continue;
                ++updated;
            }
            catch (Exception exception) {
                log.debug("Failed to update message={}: {}", new Object[]{message.getId(), exception.getMessage(), exception});
            }
        }
        return updated;
    }

    private boolean update(OutboundMessage message) {
        boolean result = false;
        String messageId = message.getProviderId();
        if (messageId != null) {
            String status = this.getStatus(messageId);
            if (RECEIVED_BY_RECIPIENT.equals(status) || DELIVERED_TO_GATEWAY.equals(status)) {
                result = this.changeStatus(message, OutboundMessage.Status.DELIVERED);
            } else if (EXPIRED.equals(status)) {
                result = this.changeStatus(message, OutboundMessage.Status.EXPIRED);
            } else if (ERROR_DELIVERING.equals(status)) {
                result = this.changeStatus(message, OutboundMessage.Status.ERROR);
            } else {
                log.debug("Cannot update message={} with Clickatell Id={}, Clickatell status={}", new Object[]{message.getId(), messageId, status});
            }
        }
        return result;
    }

    private boolean changeStatus(OutboundMessage message, OutboundMessage.Status status) {
        boolean result = false;
        if (message.canTransition(status)) {
            message.setStatus(status);
            result = true;
        } else {
            log.debug("Cannot update message={} with Clickatell Id={}, status={} to new status={}", new Object[]{message.getId(), message.getProviderId(), message.getStatus(), status});
        }
        return result;
    }

    private String getStatus(String messageId) {
        String result = null;
        try {
            SMSStatus status = this.clickatell.getStatus(messageId);
            if (status != null) {
                result = status.getStatus();
            }
        }
        catch (NotFoundException ignore) {
            log.warn("failed to get status for message={}", (Object)messageId);
        }
        return result;
    }
}

