/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.clickatell.internal.service;

import org.openvpms.clickatell.internal.api.Clickatell;
import org.openvpms.clickatell.internal.client.ClickatellClient;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.plugin.service.util.ContextClassLoaderHelper;

public class ClickatellFactory {
    private final ArchetypeService service;
    private final PasswordEncryptor encryptor;

    public ClickatellFactory(ArchetypeService service, PasswordEncryptor encryptor) {
        this.encryptor = encryptor;
        this.service = service;
    }

    public Clickatell create(IMObject config) {
        IMObjectBean bean = this.service.getBean(config);
        return this.create(bean);
    }

    public Clickatell create(IMObjectBean bean) {
        String apiKey = this.encryptor.decrypt(bean.getString("apiKey"));
        return (Clickatell)ContextClassLoaderHelper.proxy(() -> this.create(apiKey));
    }

    protected Clickatell create(String apiKey) {
        return new ClickatellClient(apiKey);
    }
}

