/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.clickatell.internal.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MultivaluedHashMap;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.proxy.WebResourceFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.openvpms.clickatell.internal.api.Clickatell;
import org.openvpms.clickatell.internal.client.ErrorHelper;
import org.openvpms.clickatell.internal.model.SMS;
import org.openvpms.clickatell.internal.model.SMSResponses;
import org.openvpms.clickatell.internal.model.SMSStatus;
import org.openvpms.ws.util.ErrorResponseFilter;
import org.openvpms.ws.util.SLF4JLoggingFeature;
import org.openvpms.ws.util.filter.JSONErrorMessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickatellClient
implements Clickatell {
    private final Clickatell client;
    private static final int TIMEOUT = 30000;
    private static final String URL = "https://platform.clickatell.com";
    private static final Logger log = LoggerFactory.getLogger(ClickatellClient.class);
    private static final String AUTHORIZATION = "Authorization";

    public ClickatellClient(String apiKey) {
        this(apiKey, URL);
    }

    public ClickatellClient(String apiKey, String url) {
        Configurable config = new ClientConfig().register((Class)JacksonFeature.class);
        ((ClientConfig)config).register(new SLF4JLoggingFeature(log, AUTHORIZATION));
        ((ClientConfig)config).register(new ErrorResponseFilter(new ClickatellErrorReader()));
        Client client = ClientBuilder.newClient((Configuration)((Object)config));
        client.property("jersey.config.client.connectTimeout", 30000);
        client.property("jersey.config.client.readTimeout", 30000);
        MultivaluedHashMap<String, Object> headers = new MultivaluedHashMap<String, Object>();
        headers.add(AUTHORIZATION, apiKey);
        WebTarget target = client.target(url);
        this.client = WebResourceFactory.newResource(Clickatell.class, target, false, headers, Collections.emptyList(), new Form());
    }

    @Override
    public SMSResponses send(SMS message) {
        return this.client.send(message);
    }

    @Override
    public SMSStatus getStatus(String messageId) {
        return this.client.getStatus(messageId);
    }

    private static class ClickatellErrorReader
    extends JSONErrorMessageReader<SMSResponses> {
        public ClickatellErrorReader() {
            super(new ObjectMapper(), SMSResponses.class);
        }

        @Override
        protected String toString(SMSResponses object) {
            String result = !object.getMessages().isEmpty() ? ErrorHelper.formatError(object.getMessages().get(0)) : ErrorHelper.formatError(object.getErrorCode(), object.getError(), object.getErrorDescription());
            return result;
        }
    }
}

