/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.ws.util.filter;

import javax.ws.rs.client.ClientResponseContext;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.ws.util.filter.AbstractErrorMessageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerialisedErrorMessageReader<T>
extends AbstractErrorMessageReader {
    private final Class<T> type;
    private static final Logger log = LoggerFactory.getLogger(AbstractSerialisedErrorMessageReader.class);

    public AbstractSerialisedErrorMessageReader(Class<T> type) {
        this.type = type;
    }

    @Override
    protected String readProtected(ClientResponseContext response) throws Throwable {
        String result = null;
        String value = super.readProtected(response);
        try {
            T object = this.deserialise(value, this.type);
            if (object != null) {
                result = StringUtils.trimToNull((String)this.toString(object));
            }
        }
        catch (Throwable exception) {
            log.error("Failed to deserialise error from response=\"" + response + "\": " + exception.getMessage(), exception);
        }
        return result;
    }

    protected abstract T deserialise(String var1, Class<T> var2) throws Throwable;

    protected String toString(T object) {
        return StringUtils.trimToNull((String)object.toString());
    }
}

