/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.clickatell.service;

import java.time.OffsetDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.openvpms.clickatell.internal.api.Clickatell;
import org.openvpms.clickatell.internal.service.ClickatellFactory;
import org.openvpms.clickatell.internal.service.MessageStatusUpdater;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.plugin.service.config.ConfigurableService;
import org.openvpms.sms.message.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class MessageStatusMonitorService
implements ConfigurableService,
DisposableBean {
    private final ArchetypeService service;
    private final Messages messages;
    private final ClickatellFactory factory;
    private final ScheduledExecutorService executor;
    private final AtomicLong counter = new AtomicLong(0L);
    private ScheduledFuture<?> future;
    private int days;
    private static final int MONITOR_FREQUENCY = 60;
    private MessageStatusUpdater updater;
    private IMObject config;
    private static final Logger log = LoggerFactory.getLogger(MessageStatusMonitorService.class);

    public MessageStatusMonitorService(ArchetypeService service, Messages messages, ClickatellFactory factory) {
        this.service = service;
        this.messages = messages;
        this.factory = factory;
        this.executor = Executors.newSingleThreadScheduledExecutor(runnable -> new Thread(runnable, "ClickatellMessageStatusMonitor" + this.counter.incrementAndGet()));
    }

    public String getArchetype() {
        return "entity.smsProviderClickatell";
    }

    public synchronized void setConfiguration(IMObject config) {
        IMObjectBean bean;
        boolean monitor;
        this.config = config;
        this.stopMonitoring();
        if (config != null && (monitor = (bean = this.service.getBean(config)).getBoolean("monitorStatus"))) {
            this.days = bean.getInt("monitorDays");
            this.startMonitoring();
        }
    }

    public synchronized IMObject getConfiguration() {
        return this.config;
    }

    public void destroy() {
        this.stopMonitoring();
    }

    protected void update(MessageStatusUpdater updater) {
        updater.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitor() {
        try {
            MessageStatusUpdater m = null;
            MessageStatusMonitorService messageStatusMonitorService = this;
            synchronized (messageStatusMonitorService) {
                if (this.config != null) {
                    Clickatell client = this.factory.create(this.config);
                    m = new MessageStatusUpdater(client, this.messages, OffsetDateTime.now().minusDays(this.days));
                    if (log.isInfoEnabled()) {
                        log.info("Checking message statuses, daysToSync=" + this.days + ", monitorFrequency=" + 60);
                    }
                    this.updater = m;
                }
            }
            if (m != null) {
                this.update(m);
            }
        }
        catch (Throwable exception) {
            log.error("Synchronisation with Clickatell failed", exception);
        }
    }

    private synchronized void stopMonitoring() {
        if (this.updater != null) {
            this.updater.stop();
            this.updater = null;
        }
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    private void startMonitoring() {
        this.stopMonitoring();
        this.future = this.executor.scheduleAtFixedRate(this::monitor, 0L, 60L, TimeUnit.MINUTES);
    }
}

