/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.client.proxy.RequestParameters;
import org.glassfish.jersey.internal.util.ReflectionHelper;

public final class WebResourceFactory
implements InvocationHandler {
    private static final String[] EMPTY = new String[0];
    private final WebTarget target;
    private final MultivaluedMap<String, Object> headers;
    private final List<Cookie> cookies;
    private final Form form;
    private static final MultivaluedMap<String, Object> EMPTY_HEADERS = new MultivaluedHashMap<String, Object>();
    private static final Form EMPTY_FORM = new Form();
    private static final List<Class<?>> PARAM_ANNOTATION_CLASSES = Arrays.asList(PathParam.class, QueryParam.class, HeaderParam.class, CookieParam.class, MatrixParam.class, FormParam.class, BeanParam.class);

    public static <C> C newResource(Class<C> resourceInterface, WebTarget target) {
        return WebResourceFactory.newResource(resourceInterface, target, false, EMPTY_HEADERS, Collections.emptyList(), EMPTY_FORM);
    }

    public static <C> C newResource(Class<C> resourceInterface, WebTarget target, boolean ignoreResourcePath, MultivaluedMap<String, Object> headers, List<Cookie> cookies, Form form) {
        return (C)Proxy.newProxyInstance(AccessController.doPrivileged(ReflectionHelper.getClassLoaderPA(resourceInterface)), new Class[]{resourceInterface}, (InvocationHandler)new WebResourceFactory(ignoreResourcePath ? target : WebResourceFactory.addPathFromAnnotation(resourceInterface, target), headers, cookies, form));
    }

    private WebResourceFactory(WebTarget target, MultivaluedMap<String, Object> headers, List<Cookie> cookies, Form form) {
        this.target = target;
        this.headers = headers;
        this.cookies = cookies;
        this.form = form;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if (args == null && method.getName().equals("toString")) {
            return this.toString();
        }
        if (args == null && method.getName().equals("hashCode")) {
            return this.hashCode();
        }
        if (args != null && args.length == 1 && method.getName().equals("equals")) {
            return this.equals(args[0]);
        }
        Class<?> proxyIfc = proxy.getClass().getInterfaces()[0];
        Class<?> responseType = method.getReturnType();
        String httpMethod = WebResourceFactory.getHttpMethodName(method);
        if (httpMethod == null) {
            Annotation ann;
            Annotation[] annotationArray = method.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (httpMethod = WebResourceFactory.getHttpMethodName((ann = annotationArray[i]).annotationType())) == null; ++i) {
            }
        }
        WebTarget newTarget = WebResourceFactory.addPathFromAnnotation(method, this.target);
        if (httpMethod == null) {
            if (newTarget == this.target) {
                throw new UnsupportedOperationException("Not a resource method.");
            }
            if (!responseType.isInterface()) {
                throw new UnsupportedOperationException("Return type not an interface");
            }
        }
        RequestParameters requestParameters = new RequestParameters(newTarget, this.headers, this.cookies, this.form);
        Annotation[][] paramAnns = method.getParameterAnnotations();
        GenericEntity<Object> entity = null;
        Type entityType = null;
        for (int i = 0; i < paramAnns.length; ++i) {
            Annotation ann;
            HashMap anns = new HashMap();
            for (Annotation ann2 : paramAnns[i]) {
                anns.put(ann2.annotationType(), ann2);
            }
            GenericEntity<Object> value = args[i];
            if (!RequestParameters.hasAnyParamAnnotation(anns)) {
                entityType = method.getGenericParameterTypes()[i];
                entity = value;
                continue;
            }
            if (value == null && (ann = (Annotation)anns.get(DefaultValue.class)) != null) {
                value = ((DefaultValue)ann).value();
            }
            if (value == null) continue;
            requestParameters.addParameter(value, anns);
        }
        newTarget = requestParameters.getNewTarget();
        if (httpMethod == null) {
            return WebResourceFactory.newResource(responseType, newTarget, true, requestParameters.getHeaders(), requestParameters.getCookies(), requestParameters.getForm());
        }
        Produces produces = method.getAnnotation(Produces.class);
        if (produces == null) {
            produces = proxyIfc.getAnnotation(Produces.class);
        }
        String[] accepts = produces == null ? EMPTY : produces.value();
        String contentType = null;
        if (entity != null) {
            Object contentTypeEntries = requestParameters.getHeaders().get("Content-Type");
            if (contentTypeEntries != null && !contentTypeEntries.isEmpty()) {
                contentType = contentTypeEntries.get(0).toString();
            } else {
                Consumes consumes = method.getAnnotation(Consumes.class);
                if (consumes == null) {
                    consumes = proxyIfc.getAnnotation(Consumes.class);
                }
                if (consumes != null && consumes.value().length > 0) {
                    contentType = consumes.value()[0];
                }
            }
        }
        Invocation.Builder builder = newTarget.request().headers(requestParameters.getHeaders()).accept(accepts);
        for (Cookie c : requestParameters.getCookies()) {
            builder = builder.cookie(c);
        }
        if (entity == null && !requestParameters.getForm().asMap().isEmpty()) {
            entity = requestParameters.getForm();
            contentType = "application/x-www-form-urlencoded";
        } else {
            if (contentType == null) {
                contentType = "application/octet-stream";
            }
            if (!requestParameters.getForm().asMap().isEmpty() && entity instanceof Form) {
                ((Form)((Object)entity)).asMap().putAll(requestParameters.getForm().asMap());
            }
        }
        GenericType responseGenericType = new GenericType(method.getGenericReturnType());
        if (entity != null) {
            if (entityType instanceof ParameterizedType) {
                entity = new GenericEntity<Object>(entity, entityType);
            }
            result = builder.method(httpMethod, Entity.entity(entity, contentType), responseGenericType);
        } else {
            result = builder.method(httpMethod, responseGenericType);
        }
        return result;
    }

    private static WebTarget addPathFromAnnotation(AnnotatedElement ae, WebTarget target) {
        Path p = ae.getAnnotation(Path.class);
        if (p != null) {
            target = target.path(p.value());
        }
        return target;
    }

    public String toString() {
        return this.target.toString();
    }

    private static String getHttpMethodName(AnnotatedElement ae) {
        HttpMethod a = ae.getAnnotation(HttpMethod.class);
        return a == null ? null : a.value();
    }
}

